require( "HiddenObject/script/style.lua" );

DialogTitleFont = {
  standardFont,
  26,
  WhiteColor
};

DialogBodyFont = {
  standardFont,
  24,
  WhiteColor
};

DialogTitleText = {
	parent=DefaultStyle,
	font = DialogTitleFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=16,y=12,w=kMax,h=30
};

DialogBodyText = {
	parent=DefaultStyle,
	font = DialogBodyFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};
FooterGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover",
};	

FooterStyle= {
	type = kPush,
	font = DialogBodyFont,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = FooterGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

MakeDialog
{
	name="timerExpiryDialog", -- Remember, this is like saying table['name']=name, so it works.
    Bitmap
    {
		image="HiddenObject/UI/Background/dialog",
		x=kCenter,
		y=kCenter - 44,

		SetStyle(DialogTitleText),
        Text
		{
			--flags = kVAlignTop + kHAlignCenter,
			name = "gameOverTitle",
			label= "gameOverTitle",
			x = 10, 
			y = 30,
		};
		
		SetStyle(DialogBodyText),
		Text
		{
			name = "timerExpired",
			label= "timerExpired",
			
		};

        SetStyle(FooterStyle),
        Button
        {
			command=
				function()
					PopModal('timerExpiryDialog');
					SwapToModal('HiddenObject/Script/hiddenobjectgame.lua');
				end;
            flags = 5,
            label = "yes",
            name = "yes",
            x = kCenter-80,
            y = -80,
        },
        
        --SetStyle(RightCurveStyle),
        Button
        {
			command=
				function() 
					PopModal('timerExpiryDialog');
					SwapToModal('HiddenObject/Script/mainmenu.lua');
                end;
            flags = 5,
            label = "no",
            name = "no",
            x = kCenter+80,
            y = -80,
        },
    },

} -- MakeDialog
